---
generated_at: 2026-02-04 11:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-Spark Web UI

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 全Claimに根拠あり。特記事項なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/ui/SparkUI.scala`（全文読取済み）
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（全文読取済み）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`（全文読取済み）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Jettyベースの組み込みWebサーバー | E-01 (23行 Jakarta Servlet import, 51行 WebUI継承) | ○ |
| C-02 | AppStatusStoreからデータ取得 | E-01 (43行) | ○ |
| C-03 | initialize()でJobsTab, StagesTab等を登録 | E-01 (98-112行) | ○ |
| C-04 | ルートリダイレクトは"/jobs/" | E-01 (114行) | ○ |
| C-05 | killEnabledの設定 | E-01 (56行) | ○ |
| C-06 | GET/POST両方でKill操作 | E-01 (122-125行) | ○ |
| C-07 | Prometheusエンドポイントのオプション | E-01 (116-118行) | ○ |
| C-08 | 静的リソースディレクトリ | E-01 (113行, 233行) | ○ |
| C-09 | 起動中メッセージ表示 | E-01 (63-69行) | ○ |
| C-10 | bind()失敗時にSystem.exit(1) | E-01 (159行) | ○ |
| C-11 | UIRootトレイトの実装 | E-01 (54行) | ○ |
| C-12 | DriverLogタブの条件付き表示 | E-01 (105-111行) | ○ |
| C-13 | StreamingJobProgressListenerのサポート | E-01 (213-221行) | ○ |
| C-14 | SecurityManagerによるアクセス制御 | E-01 (46行, 178-181行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全Claimに根拠あり、低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] WebUI.scalaの基底クラスのポートバインディングロジックを確認
- [ ] ApiRootResource.scalaのREST APIエンドポイント一覧を確認
- [ ] 各タブページの具体的な表示項目を確認
